//------------------------------------------------------------------------------
// File: svr_savetaskbuttons.cs
// This handles saving and loading on the server side for task buttons.
//
// Copyright Sandlot Games, 2007
// Author: Michael Felice
//------------------------------------------------------------------------------

// the client calls this function when it has a list of ghost ids
// that needs to be saved (these are the list of target objects
// that have tast buttons)
function serverCmdTaskButtonSaveToFile(%client, %list)
{
   // save the save ids for each of the server-side target objects
   %count = GetWordCount(%list);
   for (%index = 0; %index < %count; %index++)
   {
      %ghostID = getWord(%list, %index);
      %target = %client.resolveObjectFromGhostIndex(%ghostID);
      slgSaveInt(%target.saveID);
   }
   
   // notify the client that we are done saving the save ids of targets
   commandToClient(%client, 'TaskButtonSaveToFile');
}

function serverCmdTaskButtonsLoadFromFile(%client)
{
   // get the number of target objects we are loading
   %count = slgLoadInt();
   
   // create the list of ghost ids for every saved target object
   %list = "";
   for (%index = 0; %index < %count; %index++)
   {
      %saveID = slgLoadInt();
      %target = slgGetGameObject(%saveID);
      %ghostID = %client.getGhostID(%target);
      
      %list = %list @ %ghostID @ " ";
   }
   
   // send the list of target ghost ids to the client
   commandToClient(%client, 'TaskButtonLoadFromFile', %list);
}
